import { Router } from 'express';
import { remindersController } from './controller';
import { authenticateUser, requireVendor } from '@/middlewares/auth';
import { checkFeature } from '@/middlewares/featureGate';
import { vendorService } from '@/modules/vendors/service';

const router = Router();

// Attach vendor to req for downstream use
async function attachVendor(req: any, res: any, next: any) {
  if (req.user) {
    const { data: vendor } = await vendorService.getVendorByUserId(req.user.id);
    req.vendor = vendor || null;
  }
  next();
}

router.post('/create', authenticateUser, requireVendor, attachVendor, checkFeature('reminders'), remindersController.create);
router.get('/list', authenticateUser, requireVendor, attachVendor, checkFeature('reminders'), remindersController.list);
router.post('/send/:id', authenticateUser, requireVendor, attachVendor, checkFeature('reminders'), remindersController.send);

export default router; 